
   anim_bloom      MatrixP                                                                                MatrixV                                                                                MatrixW                                                                                SAMPLER    +      
   anim_bloom.vs  #ifdef SKINNED
	uniform mat4 pv;
	uniform mat4 fastanim_xform;
	uniform vec4 fastanim_bones[64];
#else
	uniform mat4 MatrixP;
	uniform mat4 MatrixV;
	uniform mat4 MatrixW;
#endif

attribute vec4 POS2D_UV;                   // x, y, u + samplerIndex * 2, v

varying vec3 PS_TEXCOORD;

void main()
{
#ifdef SKINNED
	// Oh damn, the samper index is encoded already in the POS2D_UV. Can I encode the array index in there as well?
	// sure we can
    	float boneIndex = floor((POS2D_UV.w + 0.5)/2.0);
    	float samplerIndex = floor(POS2D_UV.z/2.0);
	//int matrix_index = int(POSITION.z + 0.5);
	// This needs thought. There is already a V from UV in it. Can I maybe give up precision? I probably can, they're floats
	// Can I maybe store them as half floats? Does every shader model support that? HMMMMMM
        // Alternatively 4 bits from the U and 4 from the V
	int matrix_index = int(boneIndex);
    	vec3 TEXCOORD0 = vec3(POS2D_UV.z - 2.0*samplerIndex, POS2D_UV.w - 2.0 * boneIndex, samplerIndex);

	float _a = fastanim_bones[matrix_index*2].x;
	float _b = fastanim_bones[matrix_index*2].y;
	float _c = fastanim_bones[matrix_index*2].z;
	float _d = fastanim_bones[matrix_index*2].w;
	float tx = fastanim_bones[matrix_index*2+1].x;
	float ty = fastanim_bones[matrix_index*2+1].y;

	mat4 matWorld = mat4(_a,_b, 0, 0,
						 _c,_d, 0, 0,
						 0, 0, 1, 0,
						 tx, ty, 0, 1); // Column-major!

	mat4 mat = fastanim_xform * matWorld;
	mat4 pvw = pv * mat;

    	vec3 POSITION = vec3(POS2D_UV.xy, 0);
	gl_Position = pvw * vec4(POSITION, 1.0); 

//	vec4 world_pos = mat * vec4( POSITION, 1.0 );
//	gl_Position = pv * vec4(POSITION, 1.0);
#else    
    vec3 POSITION = vec3(POS2D_UV.xy, 0);
    // Take the samplerIndex out of the U.
    float samplerIndex = floor(POS2D_UV.z/2.0);
    vec3 TEXCOORD0 = vec3(POS2D_UV.z - 2.0*samplerIndex, POS2D_UV.w, samplerIndex);

    mat4 mtxPVW = MatrixP * MatrixV * MatrixW;
    gl_Position = mtxPVW * vec4( POSITION.xyz, 1.0 );
#endif

	PS_TEXCOORD = TEXCOORD0;
}

 
   anim_bloom.psT  #if defined( GL_ES )
precision mediump float;
#endif

#if defined( TRIPLE_ATLAS )
    uniform sampler2D SAMPLER[6];
#else
    uniform sampler2D SAMPLER[2];
#endif	

varying vec3 PS_TEXCOORD;

void main()
{
    vec4 colour;

#if defined( TRIPLE_ATLAS )
    if( PS_TEXCOORD.z < 0.5 )
    {
        colour.rgba = texture2D( SAMPLER[0], PS_TEXCOORD.xy );
    }
    else if( PS_TEXCOORD.z < 1.5 )
    {
        colour.rgba = texture2D( SAMPLER[1], PS_TEXCOORD.xy );
    }
    else
    {
        colour.rgba = texture2D( SAMPLER[5], PS_TEXCOORD.xy );
    }
#else
    if( PS_TEXCOORD.z < 0.5 )
    {
        colour.rgba = texture2D( SAMPLER[0], PS_TEXCOORD.xy );
    }
    else
    {
        colour.rgba = texture2D( SAMPLER[1], PS_TEXCOORD.xy );
    }
#endif

    gl_FragColor.rgba = vec4( 0, 0, 0, colour.a );
}

                    